/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion.immortaleffects;

import com.renyigesai.immortalers_delight.util.datautil.EffectData;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathlessEffect {
    private static final Map<UUID, EffectData> entityHasEffect = new ConcurrentHashMap<UUID, EffectData>();

    public static Map<UUID, EffectData> getEntityMap() {
        return entityHasEffect;
    }

    public static void applyImmortalEffect(LivingEntity entity, int duration, int amplifier) {
        if (entity == null || entity.m_213877_() || entity.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = entity.m_20148_();
        long expireTime = TimekeepingTask.getImmortalTickTime() + (long)duration * 50L;
        EffectData effectData = new EffectData(entity.m_20183_(), expireTime, amplifier, entity.m_217043_().m_188502_());
        entityHasEffect.put(uuid, effectData);
    }

    public static void removeImmortalEffect(LivingEntity entity) {
        if (entity == null || entity.m_213877_() || entity.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = entity.m_20148_();
        if (entityHasEffect.get(uuid) != null) {
            entityHasEffect.remove(uuid);
        }
        DeathlessEffect.onImmortalEffectRemove(entity);
    }

    private static void onImmortalEffectRemove(LivingEntity entity) {
    }

    @SubscribeEvent
    public static void onTick(@Nonnull TickEvent.LevelTickEvent evt) {
        HashMap<UUID, EffectData> map;
        if (evt.phase.equals((Object)TickEvent.Phase.START) && (map = new HashMap<UUID, EffectData>(entityHasEffect)).size() > 0 && TimekeepingTask.getImmortalTickTime() % 1000L * (long)(map.size() + 1) <= 50L) {
            DeathlessEffect.CheckAndClearMap(evt.level);
        }
    }

    public static void CheckAndClearMap(Level level) {
        HashMap<UUID, EffectData> needClearMap = new HashMap<UUID, EffectData>();
        for (UUID uuid : entityHasEffect.keySet()) {
            EffectData effectData = entityHasEffect.get(uuid);
            if (effectData == null || TimekeepingTask.getImmortalTickTime() <= effectData.getTime()) continue;
            needClearMap.put(uuid, effectData);
        }
        for (UUID uuid : needClearMap.keySet()) {
            ServerLevel serverLevel;
            Entity entity;
            if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(uuid)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                DeathlessEffect.removeImmortalEffect(living);
                entityHasEffect.remove(uuid);
            }
            if (!level.m_5776_()) continue;
            entityHasEffect.remove(uuid);
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_213877_() || !entity.m_6084_()) {
            return;
        }
        if (!entity.m_9236_().m_5776_()) {
            HashMap<UUID, EffectData> map = new HashMap<UUID, EffectData>(entityHasEffect);
            UUID uuid = entity.m_20148_();
            if (map.get(uuid) == null) {
                return;
            }
            Long expireTime = map.get(uuid).getTime();
            if (TimekeepingTask.getImmortalTickTime() <= expireTime) {
                if (entity.f_19802_ < 20) {
                    entity.f_19802_ = 20;
                }
            } else {
                DeathlessEffect.removeImmortalEffect(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void unAttackAble(LivingAttackEvent event) {
        LivingEntity hurtOne = event.getEntity();
        if (hurtOne.m_9236_().m_5776_()) {
            return;
        }
        if (entityHasEffect.get(hurtOne.m_20148_()) != null) {
            Long expireTime = entityHasEffect.get(hurtOne.m_20148_()).getTime();
            if (TimekeepingTask.getImmortalTickTime() <= expireTime && event.getSource().m_7639_() != null) {
                DeathlessEffect.spawnParticle((Entity)hurtOne, 0);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void unDamageAble(LivingDamageEvent event) {
        LivingEntity hurtOne = event.getEntity();
        if (hurtOne.m_9236_().m_5776_()) {
            return;
        }
        if (entityHasEffect.get(hurtOne.m_20148_()) != null) {
            Long expireTime = entityHasEffect.get(hurtOne.m_20148_()).getTime();
            if (TimekeepingTask.getImmortalTickTime() <= expireTime) {
                event.setAmount(0.0f);
                DeathlessEffect.spawnParticle((Entity)hurtOne, 1);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void unEffectAble(MobEffectEvent.Applicable event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (entityHasEffect.get(entity.m_20148_()) != null) {
            Long expireTime = entityHasEffect.get(entity.m_20148_()).getTime();
            if (TimekeepingTask.getImmortalTickTime() <= expireTime && !event.getEffectInstance().m_19544_().m_19486_()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    private static void spawnParticle(@Nonnull Entity entity, int type) {
        Level level = entity.m_9236_();
        BlockPos pPos = entity.m_20183_().m_6630_(1 + (int)entity.m_20192_());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.f_19797_ % 3 == 0) {
                Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
                double radius = entity.m_20205_();
                int i = 0;
                while ((float)i < 1.0f + entity.m_20205_() * 3.0f) {
                    double angle = Math.PI * 2 * Math.random();
                    double r = radius * Math.sqrt(Math.random());
                    double x = center.f_82479_ + r * Math.cos(angle);
                    double z = center.f_82481_ + r * Math.sin(angle);
                    double y = center.f_82480_;
                    if (type == 0) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                    }
                    if (type == 1) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123767_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                    }
                    ++i;
                }
            }
        }
    }
}

